<#ibiztemplate>
TARGET=PSSYSAPP
</#ibiztemplate>
package ${pub.getPKGCodeName()}.${app.getPKGCodeName()?lower_case};

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.zuul.EnableZuulProxy;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignClientsConfiguration;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import java.util.List;

@Slf4j
@Import({
    FeignClientsConfiguration.class
})
@EnableDiscoveryClient
@Configuration
@EnableFeignClients(basePackages = {"${pub.getPKGCodeName()}" })
@EnableZuulProxy
@ComponentScan(basePackages = {"${pub.getPKGCodeName()}"})
@MapperScan("${pub.getPKGCodeName()}.*.mapper")
@SpringBootApplication(exclude = {
        org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration.class,
        <#assign bmogo=false>
        <#if app.getAllPSAppDataEntities()??>
        <#list app.getAllPSAppDataEntities() as appde>
            <#if appde.getStorageMode()?? && appde.getStorageMode()==2>
                <#assign bmogo=true>
                <#break >
            </#if>
        </#list>
        </#if>
        <#if bmogo==false>
            org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration.class,
        </#if>
})
public class ${app.getPKGCodeName()}Application extends WebMvcConfigurerAdapter{

    public static void main(String[] args) {
        SpringApplication.run(${app.getPKGCodeName()}Application.class,args);
    }

    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        super.addArgumentResolvers(argumentResolvers);
        argumentResolvers.add(new ${pub.getPKGCodeName()}.util.web.SearchContextHandlerMethodArgumentResolver());
    }
}
